import BulletMod
import BulletTypes

--data Vector3    = Vector3 !Scalar !Scalar !Scalar
--data Matrix3x3  = Matrix3x3 !Vector3 !Vector3 !Vector3
--data Quaternion = Quaternion !Scalar !Scalar !Scalar !Scalar
--data Transform  = Transform !Matrix3x3 !Vector3

--{#fun btDefaultMotionState_new as btDefaultMotionState    {  withTransform* `Transform' , withTransform* `Transform'  } -> `BtDefaultMotionState' mkBtDefaultMotionState* #}
--{#fun btRigidBody_new as btRigidBody    `( BtMotionStateClass p1 , BtCollisionShapeClass p2 )' =>     {   `Float' , withBt* `p1' , withBt* `p2' , withVector3* `Vector3'  } 

simpleBtDiscreteDynamicsWorld = do
    dc <- btDefaultCollisionConstructionInfo
    c <- btDefaultCollisionConfiguration dc
    
    d <- btCollisionDispatcher c
    hc <- btHashedOverlappingPairCache
    b <- btDbvtBroadphase hc
    s <- btSequentialImpulseConstraintSolver
    btDiscreteDynamicsWorld d b s c

mkVehicle dw = do
{-
	btCollisionShape* chassisShape = new btBoxShape(btVector3(1.f,0.5f,2.f));
	m_collisionShapes.push_back(chassisShape);

	btCompoundShape* compound = new btCompoundShape();
	m_collisionShapes.push_back(compound);
	btTransform localTrans;
	localTrans.setIdentity();
	//localTrans effectively shifts the center of mass with respect to the chassis
	localTrans.setOrigin(btVector3(0,1,0));
-}
--    chassisShape <- btBoxShape $ Vector3 1 0.5 2
--    compound <- btCompoundShape
    return ()

main = do
    let
        v0 = Vector3 0 0 0
        v1' = Vector3 1 0 0
        v2' = Vector3 0 1 0
        v3' = Vector3 0 0 1
        v1 = Vector3 11 12 13
        v2 = Vector3 21 22 23
        v3 = Vector3 31 32 33
        vp = Vector3 2 3 4
        m3 = Matrix3x3 v1 v2 v3
        m0 = Matrix3x3 v1' v2' v3'
        t0' = Transform m0 v0
        t0 = Transform m3 vp
    
    w <- simpleBtDiscreteDynamicsWorld
    ms <- btDefaultMotionState t0' t0'

    print =<< btMotionState_getWorldTransform ms t0
    print t0
    btMotionState_setWorldTransform ms t0
    print =<< btMotionState_getWorldTransform ms t0

    bs <- btBoxShape (Vector3 1 1 1)
    rb <- btRigidBody 1 ms bs v0
    btDynamicsWorld_addRigidBody w rb
 
    btDynamicsWorld_stepSimulation w 1 5 (1.0 / 60.0)
    print =<< btMotionState_getWorldTransform ms t0

    return ()