# 1 "BasicTypes.hs_pre"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "BasicTypes.hs_pre"
--------------------------------------------------------------------------------
-- |
-- Module : Graphics.Rendering.OpenGL.GL.BasicTypes
-- Copyright : (c) Sven Panne 2002-2006
-- License : BSD-style (see the file libraries/OpenGL/LICENSE)
--
-- Maintainer : sven.panne@aedion.de
-- Stability : stable
-- Portability : portable
--
-- This module corresponds to section 2.3 (GL Command Sytax) of the OpenGL 2.1
-- specs.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.GL.BasicTypes (
   GLboolean, GLbyte, GLubyte, GLchar, GLshort, GLushort, GLint, GLuint,
   GLsizei, GLenum, GLintptr, GLsizeiptr, GLbitfield, GLfloat, GLclampf,
   GLdouble, GLclampd, Capability(..)
) where

--------------------------------------------------------------------------------

# 1 "../../../../include/HsOpenGLConfig.h" 1
# 25 "BasicTypes.hs_pre" 2

--------------------------------------------------------------------------------

import Data.Int
import Data.Word

-- If we don't find modern OpenGL headers at configuration time, make some
-- educated guesses here.
# 50 "BasicTypes.hs_pre"
--------------------------------------------------------------------------------

-- | Boolean (min. 1 bit)
type GLboolean = Word8

-- | Signed 2\'s complement binary integer (min. 8 bits)
type GLbyte = Int8

-- | Unsigned binary integer (min. 8 bits)
type GLubyte = Word8

-- | Characters making up strings
type GLchar = Int8

-- | Signed 2\'s complement binary integer (min. 16 bits)
type GLshort = Int16

-- | Unsigned binary integer (min. 16 bits)
type GLushort = Word16

-- | Signed 2\'s complement binary integer (min. 32 bits)
type GLint = Int32

-- | Unsigned binary integer (min. 32 bits)
type GLuint = Word32

-- | Non-negatitve binary integer size (min. 32 bits)
type GLsizei = Int32

-- | Enumerated binary integer value (min. 32 bits)
type GLenum = Word32

-- | Signed 2\'s complement binary integer (sufficiently large enough to hold
-- any address)
type GLintptr = Int32

-- | Non-negatitve binary integer size (sufficiently large enough to hold any
-- address)
type GLsizeiptr = Int32

-- | Bit field (min. 32 bits)
type GLbitfield = Word32

-- | Floating-point value (min. 32 bits)
type GLfloat = Float

-- | Floating-point value clamped to [0,1] (min. 32 bits)
type GLclampf = Float

-- | Floating-point value (min. 64 bits)
type GLdouble = Double

-- | Floating-point value clamped to [0,1] (min. 64 bits)
type GLclampd = Double

--------------------------------------------------------------------------------

data Capability =
     Disabled
   | Enabled
   deriving ( Eq, Ord, Show )
